#include <iostream>
#include <string>
#include <cstdlib>
#include <cstdio>
#include <algorithm>
#include <map>
#include <set>
#include <vector>
#include <cmath>
#include <cstring>
#include <queue>
#include <deque>

#define mp make_pair
#define mt(a, b, c) mp(a, mp(b, c))
#define ABS(a) ((a > 0) ? (a) : (-a))
#define ZERO(x) memset((x), 0, sizeof(x))
#define X first
#define Y second

using namespace std;
typedef long long ll;
typedef unsigned long long ull;

const int MAX_M = 1050;

ll masks[MAX_M];

int main()
{
	freopen("input.txt", "r", stdin);
	freopen("output.txt", "w", stdout);

	char base36[36];
	for (int i = 0; i <= 9; ++i)
	{
		base36[i] = i + '0';
	}
	for (char c = 'A'; c <= 'Z'; ++c)
	{
		base36[c - 'A' + 10] = c;
	}

	int n, m, q;
	while (true)
	{
		cin >> n >> m >> q;
		if (n == 0 && m == 0 && q == 0)
		{
			break;
		}

		ll allones = (1LL << (n + 1)) - 1;

		for (int i = 0; i < m; ++i)
		{
			masks[i] = allones;
		}

		ll cur_state = 0;
		for (int i = 0; i < q; ++i)
		{
			string swits;
			string bulbs;
			cin >> swits >> bulbs;
			ll sw = 0;
			for (int j = 0; j < swits.size(); ++j)
			{
				if (swits[j] == '1')
				{
					sw |= 1LL << j;
				}
			}

			cur_state ^= sw;
			ll anti_cur_state = allones ^ cur_state;
			for (int j = 0; j < m; ++j)
			{
				if (bulbs[j] == '1')
				{
					masks[j] &= cur_state;
				}
				else
				{
					masks[j] &= anti_cur_state;
				}
			}
		}

		for (int i = 0; i < m; ++i)
		{
			int swit = -1;
			for (int p = 0; p < n; ++p)
			{
				if ((masks[i] >> p) & 1LL)
				{
					if (swit == -1)
					{
						swit = p;
					}
					else
					{
						swit = -2;
					}
				}
			}
			if (swit >= 0)
			{
				cout << base36[swit];
			}
			else
			{
				cout << '?';
			}
		}
		cout << endl;
	}

	return 0;
}